/*
 * QrfeRfePurHidKeyboardReader.cpp
 *
 *  Created on: 11.12.2013
 *      Author: stefan.detter
 */

#include "../../../inc/reader/app/QrfeRfePurHidKeyboardReader.h"

QrfeRfePurHidKeyboardReader::QrfeRfePurHidKeyboardReader(QrfeProtocolHandlerRFE* ph, QObject* parent)
	: QrfeRfePurReader(ph, parent)
{
}

QrfeRfePurHidKeyboardReader::~QrfeRfePurHidKeyboardReader()
{
}


QrfeGlobal::Result QrfeRfePurHidKeyboardReader::getSettings ( QrfeRfePurHidKeyboardReader::SETTINGS& settings )
{
	QByteArray payload;
	payload.append((char)QrfeRfePurHidKeyboardReader::GET_SETTINGS);
	QByteArray response;

	trc(0, "Appl Command - Trying to get Settings");

	QrfeGlobal::Result res = m_ph->applicationCommand(payload, response);

	if(res != QrfeGlobal::RES_OK)
		return res;

	trc(0, "Appl Command - Received: " + response.toHex());

	if(response.size() < 6)
		return QrfeGlobal::RES_ERROR;

	uchar i = 0;

	settings.attenuation		= 0;
	settings.attenuation		|= (((ushort) (uchar) response.at(i++)) << 8);
	settings.attenuation		|= (ushort) (uchar) response.at(i++);
	settings.powerSafeTime		= 0;
	settings.powerSafeTime		|= (((ushort) (uchar) response.at(i++)) << 8);
	settings.powerSafeTime		|= (ushort) (uchar) response.at(i++);

	settings.prependEnter 		= response.at(i++) != 0;
	settings.appendEnter		= response.at(i++) != 0;

	settings.deleteTime			= 0;
	settings.deleteTime			|= (((ulong) (uchar) response.at(i++)) << 24);
	settings.deleteTime			|= (((ulong) (uchar) response.at(i++)) << 16);
	settings.deleteTime			|= (((ulong) (uchar) response.at(i++)) << 8);
	settings.deleteTime			|= (ulong) (uchar) response.at(i++);

	trc(0, "Appl Command - Get Settings: ");
	trc(0, "  attenuation    = " + QString::number(settings.attenuation));
	trc(0, "  powerSafeTime  = " + QString::number(settings.powerSafeTime));
	trc(0, "  prependEnter   = " + QString::number(settings.prependEnter));
	trc(0, "  appendEnter    = " + QString::number(settings.appendEnter));
	trc(0, "  deleteTime     = " + QString::number(settings.deleteTime));

	return QrfeGlobal::RES_OK;
}

QrfeGlobal::Result QrfeRfePurHidKeyboardReader::setSettings ( const QrfeRfePurHidKeyboardReader::SETTINGS& settings )
{
	trc(0, "Appl Command - Trying to Set Settings: ");
	trc(0, "  attenuation    = " + QString::number(settings.attenuation));
	trc(0, "  powerSafeTime  = " + QString::number(settings.powerSafeTime));
	trc(0, "  prependEnter   = " + QString::number(settings.prependEnter));
	trc(0, "  appendEnter    = " + QString::number(settings.appendEnter));
	trc(0, "  deleteTime     = " + QString::number(settings.deleteTime));

	QByteArray payload;
	payload.append((char)QrfeRfePurHidKeyboardReader::SET_SETTINGS);
	payload.append((uchar) (settings.attenuation >> 8));
	payload.append((uchar) (settings.attenuation));
	payload.append((uchar) (settings.powerSafeTime >> 8));
	payload.append((uchar) (settings.powerSafeTime));
	payload.append(settings.prependEnter);
	payload.append(settings.appendEnter);
	payload.append((uchar) (settings.deleteTime >> 24));
	payload.append((uchar) (settings.deleteTime >> 16));
	payload.append((uchar) (settings.deleteTime >> 8));
	payload.append((uchar) (settings.deleteTime));

	QrfeGlobal::Result res = m_ph->applicationCommand(payload);

	if(res != QrfeGlobal::RES_OK)
		return res;

	trc(0, "Appl Command - Set Settings");

	return QrfeGlobal::RES_OK;
}
